# DLP-LoRA Gradio Usage

## Basic Page

### 1. Basic LoRA Training

On this page, you can test basic models and train LoRA by filling in the required fields.

**Important Notes**:
- Regardless of the mode you're using, make sure to change the `src.Process.to_one_hot`'s `vocab_size` to match the vocab size of your LLM.
- Since different LLMs have varying end tokens, you also need to update `src.Process.generate_text` with the correct token id for your model’s end token (this part may require editing as it’s not the latest version developed).

**JSON Format**:  
- The format is `DictList`, where each dictionary contains keys "Q" and "A".

**While Training or Testing**: 
- You may need fill the Datasets Path with the write json, and if you are using testing mode of Basic model then LoRA path you can fill anything you like.

### 2. ClassifierTraining

On this page, you can Traing your own Classifier by choose different model of `albert` and `Roberta-base-distil` or `MLP`(MLP config based on the albert so while using MLP choose albert is OK)

**Important Notes**:
- The datasets which training for LoRA can be fully used by Classifier, you can use Page 3`Classifier datasets maker Fusion` to invert your LoRA datasets to Classifier datasets.

- Notice only the right format formed by Page 3 could be used to train the classifier, more details under the code

**While Training or Testing**: 
- You may need fill the Datasets Path with the write json, and if you are using testing mode of Basic model then LoRA path you can fill anything you like.

### 3. Classifier datasets maker Fusion

On this page, you can invert your LoRA datasets to Classifier datasets.

**How to use**:
1. The datasets which training for LoRA can be fully used by Classifier, you can just put your LoRA datasets which keep same format of page 1 then push the start it will out put to your folder.

2. Cause you are training the classifier so we designed the fusion function to help you fusion your different datasets

- Notice is better to sample same number of the datasets, then may give a better feed back.

### 4. DLP-LoRA Test

While you got the LoRA and Classifier, is time to start DLP-LoRA

**How to use**:
1. Firstly, you need form a `LoRA pathList`.txt and push it into the blank for our model to find your LoRAs.

2. Then you need choose the type of your classifier and filling other path follow the page's order.

3. While you filling all blank, choose start then it will start testing your DLP-LoRA

**JSON Format**:  
- The format is `DictList`, where each dictionary contains keys "Q" and "A".